/* Contains the functions associated with Interface Kits */

#ifndef __LCINTERFACEKIT__
#define __LCINTERFACEKIT__

#ifndef __EXTERNAL__
#include "lcphidget.h"
#endif

class Lcinterfacekit: public Lcphidget{
	protected:
		static int CCONV InputChangeHandler(CPhidgetInterfaceKitHandle ifKit, void *usrptr, int Index, int Value);
		static int CCONV OutputChangeHandler(CPhidgetInterfaceKitHandle ifKit, void *usrptr, int Index, int Value);
		static int CCONV SensorChangeHandler(CPhidgetInterfaceKitHandle ifKit, void *usrptr, int Index, int Value);
		
	public :
		static void phidgetsInterfaceKit_set_OnInputChange_Handler(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_set_OnOutputChange_Handler(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_set_OnSensorChange_Handler(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_create(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_getInputCount(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_getInputState(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_getOutputCount(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_getOutputState(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_setOutputState(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_getSensorCount(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_getSensorValue(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_getSensorRawValue(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_getSensorChangeTrigger(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_setSensorChangeTrigger(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_getRatiometric(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_setRatiometric(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_getDataRate(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_setDataRate(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_getDataRateMin(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
		static void phidgetsInterfaceKit_getDataRateMax(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err);
};
#endif